SET STATISTICS TIME ON
SET STATISTICS IO ON

-- Najdi pracovnky, kte maj 100 a vce schvlench hodin
-- Podmnku vyhodnocujeme pro kadho pracovnka (row-based)
SELECT PracovnikID, KrestniJmeno FROM Pracovnik
	WHERE 100 <= (
		SELECT SUM(PocetHodin)
			FROM TimesheetItem
			WHERE 
				(TimesheetItem.SchvalenoKdy IS NOT NULL)
				AND (TimesheetItem.PracovnikID = Pracovnik.PracovnikID))
				
-- Jin zpis, podmnku vyhodnocujeme hromadn (set-based)				
SELECT PracovnikID, KrestniJmeno FROM Pracovnik
	WHERE PracovnikID IN
		(SELECT TimesheetItem.PracovnikID
			FROM TimesheetItem
			WHERE 
				(TimesheetItem.SchvalenoKdy IS NOT NULL)
			GROUP BY TimesheetItem.PracovnikID
			HAVING SUM(PocetHodin) > 100)
			

GO
-- Funkce pro zjitn potu schvlench hodin pracovnka
CREATE FUNCTION dbo.GetPocetSchvalenychHodinPracovnika
	(@PracovnikID int)
RETURNS int
AS
BEGIN
	DECLARE @Result int
	SELECT @Result = SUM(PocetHodin)
				FROM TimesheetItem
				WHERE 
					(TimesheetItem.SchvalenoKdy IS NOT NULL)
					AND (TimesheetItem.PracovnikID = @PracovnikID)
	RETURN @Result
END
GO

-- Najdi pracovnky, kte maj 100 a vce schvlench hodin
-- Podmnku vyhodnocujeme pro kadho pracovnka (row-based function)
SELECT PracovnikID, KrestniJmeno FROM Pracovnik
	WHERE dbo.GetPocetSchvalenychHodinPracovnika(PracovnikID) >= 100

GO

DROP FUNCTION dbo.GetPocetSchvalenychHodinPracovnika